/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.level;

import dev.architectury.hooks.level.ExplosionHooks;
import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.entity.LivingEntityJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.level.LevelEventJS;
import dev.latvian.mods.kubejs.level.LevelJS;
import dev.latvian.mods.kubejs.player.EntityArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ExplosionEventJS
extends LevelEventJS {
    protected final Level level;
    protected final Explosion explosion;

    public ExplosionEventJS(Level level, Explosion explosion) {
        this.level = level;
        this.explosion = explosion;
    }

    @Override
    public LevelJS getLevel() {
        return this.levelOf(this.level);
    }

    public Vec3 getPosition() {
        return ExplosionHooks.getPosition((Explosion)this.explosion);
    }

    public double getX() {
        return this.getPosition().f_82479_;
    }

    public double getY() {
        return this.getPosition().f_82480_;
    }

    public double getZ() {
        return this.getPosition().f_82481_;
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.level, new BlockPos(this.getPosition()));
    }

    @Nullable
    public LivingEntityJS getExploder() {
        return this.getLevel().getLivingEntity((Entity)this.explosion.m_46079_());
    }

    public static class Post
    extends ExplosionEventJS {
        private final List<Entity> affectedEntities;

        public Post(Level level, Explosion explosion, List<Entity> affectedEntities) {
            super(level, explosion);
            this.affectedEntities = affectedEntities;
        }

        public EntityArrayList getAffectedEntities() {
            return new EntityArrayList(this.getLevel(), this.affectedEntities);
        }

        public void removeAffectedEntity(EntityJS entity) {
            this.affectedEntities.remove(entity.minecraftEntity);
        }

        public void removeAllAffectedEntities() {
            this.affectedEntities.clear();
        }

        public List<BlockContainerJS> getAffectedBlocks() {
            ArrayList<BlockContainerJS> list = new ArrayList<BlockContainerJS>(this.explosion.m_46081_().size());
            for (BlockPos pos : this.explosion.m_46081_()) {
                list.add(new BlockContainerJS(this.level, pos));
            }
            return list;
        }

        public void removeAffectedBlock(BlockContainerJS block) {
            this.explosion.m_46081_().remove(block.getPos());
        }

        public void removeAllAffectedBlocks() {
            this.explosion.m_46081_().clear();
        }

        public void removeKnockback() {
            this.explosion.m_46078_().clear();
        }
    }

    public static class Pre
    extends ExplosionEventJS {
        public Pre(Level level, Explosion explosion) {
            super(level, explosion);
        }

        @Override
        public boolean canCancel() {
            return true;
        }

        public float getSize() {
            return this.explosion.f_46017_;
        }

        public void setSize(float s) {
            this.explosion.f_46017_ = s;
        }
    }
}

